/*******************************************************************/
/*          Head file of VS1003B.c  for  Mega8 MP3 Player          */
/*                                                                 */
/* Platform   : AVRStudio4.13 b528 + WinAVR20070525                */
/*              optimize -0s                                       */
/* Author     : bozai(Zhang Qibo)                                  */
/* E-mail     : sudazqb@163.com                                    */
/* MSN        : zhangqibo_1985@hotmail.com                         */
/* Date       : 2006-05-09                                         */
/*******************************************************************/
/*2007-05-04: add slow start up code, and add enough dealy         */
/*2007-04-21:                                                      */
/*******************************************************************/

#ifndef __VS1003B_H__
#define __VS1003B_H__

#include "config.h"


#define PORT_INI()        VS1003B_DDR |= _BV(VS1003B_XCS)|_BV(VS1003B_XRESET)|_BV(VS1003B_XDCS)

#define VS1003B_XCS_H()    VS1003B_PORT |=  _BV(VS1003B_XCS)
#define VS1003B_XCS_L()    VS1003B_PORT &= ~_BV(VS1003B_XCS)

#define VS1003B_XRESET_H()    VS1003B_PORT |=  _BV(VS1003B_XRESET)
#define VS1003B_XRESET_L()    VS1003B_PORT &= ~_BV(VS1003B_XRESET)

#define VS1003B_XDCS_H()    VS1003B_PORT |=  _BV(VS1003B_XDCS)
#define VS1003B_XDCS_L()    VS1003B_PORT &= ~_BV(VS1003B_XDCS)

extern void VS1003B_SPI_Low(void);
extern void VS1003B_SPI_High(void);
extern unsigned char VS1003B_WriteByte(unsigned char CH);
extern unsigned char VS1003B_ReadByte(void);
extern void VS1003B_WriteCMD(unsigned char addr, unsigned int dat);
extern unsigned int VS1003B_ReadCMD(unsigned char addr);
extern void VS1003B_WriteDAT(unsigned char dat);
extern unsigned char VS1003B_Init(void);
extern void VS1003B_SoftReset(void);
#endif
